#include "PoolTable.h"



PoolTable::PoolTable()
{
	//Set the positions for the shadow
	lightPosition[0] = 6.0f;
	lightPosition[1] = 3.75f;
	lightPosition[2] = -9.25f;
}


PoolTable::~PoolTable()
{
}

bool PoolTable::loadMTL(char* modelFilename, char* mtlFilename, int renderingShape)
{
	Model::loadMTL(modelFilename, mtlFilename, renderingShape);	//Table
	_PoolLight.loadMTL("Assets/Models/poolLight.obj", "Assets/Models/poolLight.mtl", GL_TRIANGLES);	//Overhanging Light

	for (int i = 0; i < 15; i++)
	{
		_PoolBalls[i] = Sphere(loadTextureRet("Assets/Textures/Pool Balls/Ball" + std::to_string(i + 1) + ".png"), 25, 25, 0.1f);	//Load all pool balls
	}

	return true;
}

void PoolTable::setSpotlights(SpotLight* one, SpotLight* two)
{
	_SpotOne = one;
	_SpotTwo = two;
}

void PoolTable::render(Vector3 position)
{
	//Clear the shadow matrix
	std::fill(std::begin(shadowMatrix), std::end(shadowMatrix), 0.0f);

	//Generate shadow matrix for lights that are on
	if (_SpotOne->GetIsOn())
	{
		Shadow::generateShadowMatrix(shadowMatrix, &_SpotOne->GetPosition()[0], floorVerts);
	}

	if (_SpotTwo->GetIsOn())
	{
		Shadow::generateShadowMatrix(shadowMatrix, &_SpotTwo->GetPosition()[0], floorVerts);
	}

	//Shadow of model
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);

	glPushMatrix();
		glColor3f(0.1f, 0.1f, 0.1f); // Shadow's colour
		glPushMatrix();
			glMultMatrixf((GLfloat *)shadowMatrix);
			glTranslatef(position.x, position.y, position.z);
			Model::render();
		glPopMatrix();
	glPopMatrix();

	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);

	//Model
	glPushMatrix();
		glTranslatef(position.x, position.y, position.z);

		//Pool Balls
		glPushMatrix();
			glTranslatef(0.0f, 0.35f, -0.70f);
			glScalef(0.65f, 0.65f, 0.65f);

			glPushMatrix();
				_PoolBalls[0].Draw();

				glPushMatrix();
					glTranslatef(0.0, 0.0f, -0.15f);

					glPushMatrix();
						glTranslatef(0.1f, 0.0f, 0.0f);
						_PoolBalls[1].Draw();
					glPopMatrix();

					glPushMatrix();
						glTranslatef(-0.1f, 0.0f, 0.0f);
						_PoolBalls[2].Draw();
					glPopMatrix();

					glPushMatrix();
						glTranslatef(0.0, 0.0f, -0.15f);

						glPushMatrix();
							glTranslatef(0.2f, 0.0f, 0.0f);
							_PoolBalls[3].Draw();
						glPopMatrix();

						_PoolBalls[7].Draw();

						glPushMatrix();
							glTranslatef(-0.2f, 0.0f, 0.0f);
							_PoolBalls[5].Draw();
						glPopMatrix();

						glPushMatrix();
							glTranslatef(0.0, 0.0f, -0.15f);

							glPushMatrix();
								glTranslatef(0.3f, 0.0f, 0.0f);
								_PoolBalls[6].Draw();
							glPopMatrix();

							glPushMatrix();
								glTranslatef(0.1f, 0.0f, 0.0f);
								_PoolBalls[4].Draw();
							glPopMatrix();

							glPushMatrix();
								glTranslatef(-0.1f, 0.0f, 0.0f);
								_PoolBalls[8].Draw();
							glPopMatrix();

							glPushMatrix();
								glTranslatef(-0.3f, 0.0f, 0.0f);
								_PoolBalls[9].Draw();
							glPopMatrix();

							glPushMatrix();
								glTranslatef(0.0, 0.0f, -0.15f);

								glPushMatrix();
									glTranslatef(0.4f, 0.0f, 0.0f);
									_PoolBalls[10].Draw();
								glPopMatrix();

								glPushMatrix();
									glTranslatef(0.2f, 0.0f, 0.0f);
									_PoolBalls[11].Draw();
								glPopMatrix();

								_PoolBalls[12].Draw();

								glPushMatrix();
									glTranslatef(-0.2f, 0.0f, 0.0f);
									_PoolBalls[13].Draw();
								glPopMatrix();

								glPushMatrix();
									glTranslatef(-0.4f, 0.0f, 0.0f);
									_PoolBalls[14].Draw();
								glPopMatrix();
							glPopMatrix();
						glPopMatrix();
					glPopMatrix();
				glPopMatrix();

				glTranslatef(0.0f, 0.5f, 1.0f);
				_PoolLight.render();	//Overhanging Light
			glPopMatrix();
		glPopMatrix();

		glScalef(1.0f, 1.0f, 1.0f);	//Reset scale

		Model::render();	//Table
	glPopMatrix();
}
